/* 
 * Copyright 2014 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.os.Parcel;
import android.os.Parcelable;

/*
 *  Represents information about WLAN extended information,
 *  as received from or set to the Fritzbox 
 */
public class WLANExtInfo implements Parcelable
{
	/*
		NewX_AVM-DE_APEnabled		 out	String
		NewX_AVM-DE_APType			 out	String	"guest" "normal"
		NewX_AVM-DE_TimeoutActive	 out	String
		NewX_AVM-DE_Timeout			 out	String
		NewX_AVM-DE_TimeRemain		 out	String
		NewX_AVM-DE_NoForcedOff		 out	String
		NewX_AVM-DE_UserIsolation	 out	String
		NewX_AVM-DE_EncryptionMode	 out	String
		NewX_AVM-DE_LastChangedStamp out	String
	 */
	
	private String mAPEnabled = "";
	private String mAPType = "";
	private String mTimeoutActive = "";
	private String mTimeout = "";
	private String mTimeRemain = "";
	private String mNoForcedOff = "";
	private String mUserIsolation = "";
	private String mEncryptionMode = "";
	private String mLastChangedStamp = "";
	
	public String getAPEnabled() {
		return mAPEnabled;
	}

	public void setAPEnabled(String mAPEnabled) {
		this.mAPEnabled = mAPEnabled;
	}

	public String getAPType() {
		return mAPType;
	}

	public void setAPType(String mAPType) {
		this.mAPType = mAPType;
	}

	public String getTimeoutActive() {
		return mTimeoutActive;
	}

	public void setTimeoutActive(String mTimeoutActive) {
		this.mTimeoutActive = mTimeoutActive;
	}

	public String getTimeout() {
		return mTimeout;
	}

	public void setTimeout(String mTimeout) {
		this.mTimeout = mTimeout;
	}

	public String getTimeRemain() {
		return mTimeRemain;
	}

	public void setTimeRemain(String mTimeRemain) {
		this.mTimeRemain = mTimeRemain;
	}

	public String getNoForcedOff() {
		return mNoForcedOff;
	}

	public void setNoForcedOff(String mNoForcedOff) {
		this.mNoForcedOff = mNoForcedOff;
	}

	public String getUserIsolation() {
		return mUserIsolation;
	}

	public void setUserIsolation(String mUserIsolation) {
		this.mUserIsolation = mUserIsolation;
	}

	public String getEncryptionMode() {
		return mEncryptionMode;
	}

	public void setEncryptionMode(String mEncryptionMode) {
		this.mEncryptionMode = mEncryptionMode;
	}

	public String getLastChangedStamp() {
		return mLastChangedStamp;
	}

	public void setLastChangedStamp(String mLastChangedStamp) {
		this.mLastChangedStamp = mLastChangedStamp;
	}

	public WLANExtInfo()
	{
	}
	
	public WLANExtInfo(Parcel in)
	{
		mAPEnabled = in.readString();
		mAPType = in.readString();
		mTimeoutActive = in.readString();
		mTimeout = in.readString();
		mTimeRemain = in.readString();
		mNoForcedOff = in.readString();
		mUserIsolation = in.readString();
		mEncryptionMode = in.readString();
		mLastChangedStamp = in.readString();
	}

	public int describeContents()
	{
		return 0;
	}

	public static final Parcelable.Creator<WLANExtInfo> CREATOR =
			new Parcelable.Creator<WLANExtInfo>()
	{
		public WLANExtInfo createFromParcel(Parcel in)
		{
			return new WLANExtInfo(in);
		}

		public WLANExtInfo[] newArray(int size)
		{
			return new WLANExtInfo[size];
		}
	};

	public void writeToParcel(Parcel out, int flags)
	{
		out.writeString(mAPEnabled);
		out.writeString(mAPType);
		out.writeString(mTimeoutActive);
		out.writeString(mTimeout);
		out.writeString(mTimeRemain);
		out.writeString(mNoForcedOff);
		out.writeString(mUserIsolation);
		out.writeString(mEncryptionMode);
		out.writeString(mLastChangedStamp);
	}
}