/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.util;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.view.View;

import de.avm.fundamentals.logger.FileLog;

/**
 * ClickListener starts writing a new email
 */
public class OnClickCallEmail implements View.OnClickListener
{
    private static final String TAG = "OnClickCallEmail";
	protected final String mEmailAddress;

	public OnClickCallEmail(String email)
	{
		mEmailAddress = email;
	}

	public void onClick(View view)
	{
		if ((mEmailAddress != null) && (mEmailAddress.length() > 0))
		{
			Intent intent = new Intent(Intent.ACTION_SENDTO,
					Uri.fromParts("mailto", mEmailAddress, null));
			try
			{
				view.getContext().startActivity(intent);
			}
			catch (ActivityNotFoundException e)
			{
                FileLog.w(TAG, e.getMessage(), e);
			}
		}
	}
}
