/* 
 * Copyright 2011 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.gui;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.MotionEvent;
import android.widget.TextView;

public class WaitDialog extends ProgressDialog
{
	/**
	 * Shows a not cancelable indeterminate progress dialog
	 * 
	 * @param context
	 * 			the parent context
	 * @param message
	 * 			the message within the dialog
	 * @return
	 * 			the dialog
	 */
	public static WaitDialog show(Context context, int message)
	{
		WaitDialog dialog = new WaitDialog(context);
		dialog.setMessage(context.getString(message));
		dialog.setCancelable(false);
		
		dialog.show();
		return dialog;
	}

	/**
	 * Shows a cancelable indeterminate progress dialog
	 * 
	 * @param context
	 * 			the parent context
	 * @param message
	 * 			the message within the dialog
	 * @param listener
	 * 			the cancel listener
	 * @return
	 * 			the dialog
	 */
	public static WaitDialog show(Context context, int message,
			DialogInterface.OnCancelListener listener)
	{
		WaitDialog dialog = new WaitDialog(context);
		dialog.setMessage(context.getString(message));
		dialog.setCancelable(true);
		if (listener != null) dialog.setOnCancelListener(listener);
		
		dialog.show();
		return dialog;
	}
	
	private WaitDialog(Context context)
	{
		super(context);
		setIndeterminate(true);
	}

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
    	super.onCreate(savedInstanceState);

		// text color of this apps theme is hard to read in default
    	// colored ProgressDialog 
		TextView text = (TextView)findViewById(android.R.id.message);
		if (text != null)
			text.setTextAppearance(getContext(),
					android.R.style.TextAppearance_Medium);
    }

    public boolean onTouchEvent(MotionEvent event)
    {
    	// don't cancel on touches outside window
        return false;
    }
}
